#include <bits/stdc++.h>
#define ll long long
using namespace std;

const int MAXN = 3e5 + 5;
int N, M;
struct vektor
{
    ll x, y;
    int id;
}A[2 * MAXN];

ll square(ll a) {return a * a;}
ll cross_product(vektor a, vektor b) {return a.x * b.y - a.y * b.x;}
ll dot_product(vektor a, vektor b) {return a.x * b.x + a.y * b.y;}
bool positive(vektor a) {return (a.y > 0) or (a.y == 0 and a.x > 0);}
bool cmp(vektor a, vektor b)
{
    bool ba = positive(a);
    bool bb = positive(b);
    if(ba != bb) return ba > bb;
    ll cp = cross_product(a, b);
    if(cp) return cp > 0;
    ll d1 = square(a.x) + square(a.y);
    ll d2 = square(b.x) + square(b.y);
    if(d1 != d2) return d1 < d2;
    return a.id < b.id;
}

int main()
{
    ios_base::sync_with_stdio(false), cin.tie(0), cout.tie(0);
    cin >> M;
    N = M;
    for(int i = 1, j = 1; i <= M; i++)
    {
        ll x, y;
        cin >> x >> y;
        if(x == 0 and y == 0)
        {
            N--;
            continue;
        }
        A[j].x = x;
        A[j].y = y;
        A[j].id = i;
        j++;

    }
    sort(A + 1, A + N + 1, cmp);
    for(int i = 1; i <= N; i++) A[i + N] = A[i];
    ll mx = 0;
    ll cur = 0;
    ll curx = 0;
    ll cury = 0;
    int l, r;
    for(int i = 1, j = 1; i <= N; i++)
    {
        while(j < i + N and (cross_product(A[i], A[j]) > 0 or (cross_product(A[i], A[j]) == 0 and dot_product(A[i], A[j]) >= 0)))
        {
            curx += A[j].x;
            cury += A[j].y;
            cur = square(curx) + square(cury);
            if(cur > mx)
            {
                l = i;
                r = j;
                mx = cur;
            }
            j++;
        }
        curx -= A[i].x;
        cury -= A[i].y;
        cur = square(curx) + square(cury);
        if(cur > mx)
        {
            l = i + 1;
            r = j - 1;
            mx = cur;
        }
    }
    cout << r - l + 1 << "\n";
    for(int i = l; i <= r; i++) cout << A[i].id << " ";
    cout << "\n";

    return 0;
}